standardFont = "fonts/tekton_pro.mvec";
bigButtonFont = "fonts/tekton_pro.mvec";
--bigButtonFont = "fonts/playbill.mvec";

GreenColor = Color(0,100,0,255);
BlackColor = Color(0,0,0,255);
BlueColor = Color(77,115,178,255);
DarkBlueColor = Color(40,60,120,255);
DarkRedColor = Color(158,67,97,255);
WhiteColor = Color(255,255,255,255);
GoldColor  = Color(255,200,0,210);
MenuButtonFontColor = Color(255,255,255,255);

StButtonGraphicsSm = {
    "buttons/button_small_n",
    "buttons/button_small_p",
    "buttons/button_small_a"
};
StButtonGraphicsMid = {
    "buttons/button_mid_n",
    "buttons/button_mid_p",
    "buttons/button_mid_a"
};
StButtonGraphicsMidBig = {
    "buttons/button_midbig_n",
    "buttons/button_midbig_p",
    "buttons/button_midbig_a"
};
StButtonGraphicsBig = {
    "buttons/button_long_n",
    "buttons/button_long_p",
    "buttons/button_long_a"
};

TutorialButton1 = {
    "buttons/tutorial_button1",
    "buttons/tutorial_button1",
    "buttons/tutorial_button1"
};

StandardButtonGraphics = {
    "buttons/buttonup",
    "buttons/buttondown",
    "buttons/buttonrollover"
};

TutorialButton = {
    "buttons/tutorial_button",
    "buttons/tutorial_button",
    "buttons/tutorial_button"
};

TutorialSkipButton = {
    "buttons/tut_skip_but",
    "buttons/tut_skip_but",
    "buttons/tut_skip_but"
};


LevelCompleteButton = {
    "buttons/pad_but",
    "buttons/pad_but",
    "buttons/pad_but"
};

LongButtonGraphics = {
    "buttons/long_button_up.png",
    "buttons/long_button_down.png",
    "buttons/long_button_over.png"
};

CheckboxButtonGraphics = {
    "buttons/checkup",
    "buttons/checkdown",
    "buttons/checkover",
    "buttons/checkdownover"
};

StandardButtonFont = {
  standardFont, --bigButtonFont,
  24,--18,
  WhiteColor
};
StandardButtonFontWhite = {
  standardFont, --bigButtonFont,
  24,--18,
  WhiteColor
};

MenuButtonFont = {
  bigButtonFont,
  30,--18,
  WhiteColor
};

DialogTitleFont = {
  standardFont,
  20,
  BlackColor
};

BlackButtonFont ={
  standardFont,
  30,
  BlackColor
};

DialogBodyFont = {
  standardFont,
  18,
  BlackColor
};

DefaultStyle = {
    font=DialogBodyFont,
    sound = kDefaultButtonSound,
};

DialogTitleText = {
    parent=DefaultStyle,
    font = DialogTitleFont,
    flags = kVAlignCenter + kHAlignLeft,
    x=16,y=12,w=kMax,h=30
};

DialogBodyText = {
    parent=DefaultStyle,
    font = DialogBodyFont,
    flags = kVAlignCenter + kHAlignCenter,
    x=0,y=46,w=kMax,h=kMax-60
};

SliderStyle = 
{
    parent=DefaultStyle,
    railtop = "slider/bar",
    railmid = "slider/bar",
    railbot = "slider/bar",
    sliderimage = "slider/sliderknob",
    sliderrollimage = "slider/sliderknobover",

    yoffset = -1, -- scoot the slider down by one pixel to center it.
};

kDefaultButtonSound="audio/sfx/success_click.ogg";  --"audio/sfx/wood_button.ogg";

MenuButtonStyle = {
    parent = DefaultStyle,
    font = MenuButtonFont,
    sound = kDefaultButtonSound,
    graphics = {},
    w=169, h=40
};

ButtonStyle = {
    parent = DefaultStyle,
    font = StandardButtonFont,
    sound = kDefaultButtonSound,
    type= kPush,
    graphics = StandardButtonGraphics,
};

LongButtonStyle = {
    parent = ButtonStyle,
    graphics = LongButtonGraphics
};


MenuButtonStyle = {
    parent = ButtonStyle,
    graphics = StButtonGraphicsMidBig,            
    font = igButtonFontWhite
};

CheckboxButtonStyle = {
    parent = DefaultStyle,
    font = StandardButtonFont,
    type = kToggle,
    sound = kDefaultButtonSound,
    graphics = CheckboxButtonGraphics,
};

SetDefaultStyle(DefaultStyle);

-- Create a TButton with a label
--
-- We're overriding the default "Button" here with
-- some custom behavior. Specifically, we're layering
-- a Text{} object on top of every button, and it's placed
-- on all layers (up, down, roll-over).
function Button( button )
    return function()
        -- Grab the label from the button or current style
        if (GetTag(button,"label")) then

            -- Look for text dimensions
            local tx = GetTag(button,"tx");
            local ty = GetTag(button,"ty");
            local tw = GetTag(button,"tw");
            local th = GetTag(button,"th");

            -- Set defaults
            if (not tx) then
                tx = 0;
            end
            if (not ty) then
                ty = 0;
            end
            if (not tw) then
                tw=kMax ;
            end
            if (not th) then
                th=kMax ;
            end

            -- Get the label
            local label = GetTag(button,"label");
            
            local defflags = kPushButtonAlignment ;
            if (GetTag(button,"type")==kToggle) then
                defflags = kToggleButtonAlignment ;
            elseif (GetTag(button,"type")==kRadio) then
                defflags = kRadioButtonAlignment ;
            end

            local textfactory = GetTag(button,"textfactory");
            if (not textfactory) then
                textfactory = "_text"
            end
            table.insert(button,
                SelectLayer( kAllLayers ) 
            );
            -- Grow our window to encompass any children we've added
            -- already.
            table.insert(button,
                FitToChildren()
            );

            table.insert(button,
                AppendStyle{ font=button.font; flags=button.flags; } 
            );

            table.insert(button,
                Text
                {
                    label=label,
                    x=tx, y=ty, w=tw, h=th,
                    name='label',
                    defflags =defflags 
                }
            )
        end

        -- Type name of window to create; in our case, "Button".
        -- If you want to create a derived button type, you can do that here.
        if( button.typename == nil )then
            button.typename='Button'; end;
        DoWindow( button )
    end
end


function FlashButton1(button)
    button.typename = "FlashButton1";
    return Button(button);
end

-- Create several bits of text that combine to make a blended shadow
function ColorShadowText( x,y,size, label, color )

    return Group(
        {
        -- Add these traits to the current style
            AppendStyle{ x=x, y=y, w=kMax, h=kMax, label=label },
            AppendStyle{ font = { standardFont, size, Color(0,0,0,40)} },
            Text{ y=y+4 },
            AppendStyle{ font = { standardFont, size, Color(0,0,0,255)} },
            Text{ y=y+2 },
            AppendStyle{ font = { standardFont, size, color } } ,
            Text{},
        }
    )
end

kMenuButtonFontSize = 22;

function MenuButtonLabel( label, color, colorHighlight )

    if not color then
        color =Color(192,207,255,255);  -- the default colors
        colorHighlight=Color(255,255,255,255)
    end

    return Group{
        Bitmap
        {
            image="backgrounds/bar",
            x=0,y=0,scale=1
        },
        SelectLayer(0),
        ColorShadowText(5,8,kMenuButtonFontSize, label, color ),
        SelectLayer(1),
        ColorShadowText(5,8,kMenuButtonFontSize, label, colorHighlight ),
        SelectLayer(2),
        ColorShadowText(5,8,kMenuButtonFontSize, label, colorHighlight )
    }

end

-- Create a more limited-use button type here; the label is defined inline
-- with ButtonShadowLabel above
function MenuButton( button )
    return function()
        -- Creation function for generic window types
        button.create=GenericCreate;

        -- Type name of window to create; in our case, "Button".
        -- If you want to create a derived button type, you can do that here.
        button.typename='Button';
        DoWindow( button )
    end
end

kIllegalNameChars = "!@#$%^&*()><\\\"\'[]{}|?/+=~`.,;:-";